/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.util;

import java.util.concurrent.atomic.AtomicInteger;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.modifiers.ModifierManager;
import slimeknights.tconstruct.library.modifiers.util.LazyModifier;

public class DynamicModifier<T>
extends LazyModifier {
    private static final AtomicInteger INVALIDATION_COUNTER = new AtomicInteger(0);
    private final Class<T> classFilter;
    private int invalidationCount = -1;

    public DynamicModifier(ModifierId id, Class<T> classFilter) {
        super(id);
        this.classFilter = classFilter;
    }

    @Override
    public boolean isBound() {
        return super.isBound() && this.classFilter.isInstance(this.getUnchecked());
    }

    @Override
    protected Modifier getUnchecked() {
        if (this.invalidationCount < INVALIDATION_COUNTER.get()) {
            this.result = null;
        }
        if (this.result == null) {
            this.result = ModifierManager.getValue(this.id);
            this.invalidationCount = INVALIDATION_COUNTER.get();
        }
        return this.result;
    }

    @Override
    public Modifier get() {
        if (!ModifierManager.INSTANCE.isDynamicModifiersLoaded()) {
            throw new IllegalStateException("Cannot fetch a dynamic modifiers before datapacks load");
        }
        Modifier result = this.getUnchecked();
        if (result == ModifierManager.INSTANCE.getDefaultValue()) {
            throw new IllegalStateException("Dynamic modifier for " + String.valueOf((Object)this.id) + " returned " + String.valueOf((Object)ModifierManager.EMPTY) + ", this typically means the modifier is not registered");
        }
        if (!this.classFilter.isInstance(result)) {
            throw new IllegalStateException("Dynamic modifier is not the required type");
        }
        return result;
    }

    public T asType() {
        return this.classFilter.cast(this.get());
    }

    @Override
    public String toString() {
        return "DynamicModifier{" + String.valueOf((Object)this.id) + ",filter=" + this.classFilter.getSimpleName() + "}";
    }

    public static void init() {
        ModifierManager.ModifiersLoadedEvent.EVENT.register(e -> INVALIDATION_COUNTER.incrementAndGet());
    }
}

